---
title: OWASP ruleset concepts · Cloudflare Web Application Firewall (WAF) docs
description: "The paranoia level (PL) classifies OWASP rules according to their
  aggressiveness. Paranoia levels vary from PL1 to PL4, where PL4 is the most
  strict level:"
lastUpdated: 2025-10-16T09:35:23.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/managed-rules/reference/owasp-core-ruleset/concepts/
  md: https://developers.cloudflare.com/waf/managed-rules/reference/owasp-core-ruleset/concepts/index.md
---

## Paranoia level

The paranoia level (PL) classifies OWASP rules according to their aggressiveness. Paranoia levels vary from PL1 to PL4, where PL4 is the most strict level:

* PL1 (default value)
* PL2
* PL3
* PL4

Each rule in the OWASP managed ruleset is associated with a paranoia level. Rules associated with higher paranoia levels are considered more aggressive and provide increased protection. However, they might cause more legitimate traffic to get blocked due to false positives.

When you configure the paranoia level of the OWASP ruleset, you are enabling all the rules belonging to all paranoia levels up to the level you select. For example, if you configure the ruleset paranoia level to PL3, you are enabling rules belonging to paranoia levels PL1, PL2, and PL3.

When you set the ruleset paranoia level, the WAF enables the corresponding rules in bulk. You then can disable specific rules individually or by tag, if needed. If you use the highest paranoia level (PL4) you will probably need to disable some of its rules for applications that need to receive complex input patterns.

## Request threat score

Each OWASP rule that matches the current request has an associated score. The request threat score is the sum of the individual scores of all OWASP rules that matched the request.

## Score threshold

The score threshold (or anomaly threshold) defines the minimum cumulative score — obtained from matching OWASP rules — for the WAF to apply the configured OWASP ruleset action.

The available score thresholds are the following:

* *Low – 60 and higher*
* *Medium – 40 and higher* (default value)
* *High – 25 and higher*

Each threshold (*Low*, *Medium*, and *High*) has an associated value (*60*, *40*, and *25*, respectively). Configuring a *Low* threshold means that more rules will have to match the current request for the WAF to apply the configured ruleset action.

When the OWASP Anomaly Score Threshold is set to *High*, file uploads may trigger the `949110: Inbound Anomaly Score Exceeded` rule due to the lower amount of scoring rules needed. Consider adjusting the threshold level, [adjusting individual rules](https://developers.cloudflare.com/waf/managed-rules/deploy-zone-dashboard/#configure-a-single-rule-in-a-managed-ruleset) in the ruleset, or [creating an exception](https://developers.cloudflare.com/waf/managed-rules/waf-exceptions/) if excessive false positives occur.

For an example, refer to [OWASP evaluation example](https://developers.cloudflare.com/waf/managed-rules/reference/owasp-core-ruleset/example/).
