---
title: Customer Metadata Boundary · Cloudflare Data Localization Suite docs
description: As part of the Data Localization Suite, the Customer Metadata
  Boundary (CMB) ensures that Customer Logs — any traffic metadata that can
  identify a customer’s end user (that is, contains the customer's Account ID) —
  will stay in the EU (European Union) or in the US (United States), depending
  on the region the customer selects. For example, if a customer selects the EU
  Customer Metadata Boundary, metadata will only be sent to our core data center
  located in the European Union.
lastUpdated: 2025-07-16T14:37:31.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/data-localization/metadata-boundary/
  md: https://developers.cloudflare.com/data-localization/metadata-boundary/index.md
---

As part of the Data Localization Suite, the Customer Metadata Boundary (CMB) ensures that Customer Logs — any traffic metadata that can identify a customer’s end user (that is, contains the customer's [Account ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/)) — will stay in the `EU` (European Union) or in the `US` (United States), depending on the region the customer selects. For example, if a customer selects the `EU` Customer Metadata Boundary, metadata will **only** be sent to our core data center located in the European Union.

An exception is made if "Allow out-of-region access" is enabled. When enabled, Customer Logs will still be stored in the configured regions but will be accessible to authorized end users, regardless of physical location. Refer to [Out of region access](https://developers.cloudflare.com/data-localization/metadata-boundary/out-of-region-access/) for more details.

## Customer traffic metadata flow

The following diagram is a high-level example of the flow of how metadata about a customer's traffic is generated on a Cloudflare data center. Logs are exclusively sent to the EU core data center for Cloudflare customers and their authorized users to access and view.



```mermaid
sequenceDiagram
    participant UserEU as End user
    participant CloudflarePoP as Closest data center
    participant EUCoreDC as Core data center in EU
    participant CloudflareSuperAdmin as Admin

    UserEU->>CloudflarePoP: Connects
    Note right of CloudflarePoP: Customer Logs generated <br> (for example, HTTP requests and Firewall events)
    CloudflarePoP-->>EUCoreDC: Forwards encrypted Customer Logs
    Note right of EUCoreDC: Authorized users can view Logs & Analytics <br> on the UI or via API
    CloudflareSuperAdmin->>EUCoreDC: Authenticated access
    EUCoreDC->>CloudflareSuperAdmin: Logs & Analytics
    CloudflarePoP->>UserEU: Response
```



## Log management

Additionally, customers have the option to configure [Logpush](https://developers.cloudflare.com/logs/logpush/) to push their Customer Logs to various storage services, SIEMs, and log management providers.

## Product specific-behavior

For detailed information about product-specific behavior regarding Metadata Boundary, refer to the [Cloudflare product compatibility](https://developers.cloudflare.com/data-localization/compatibility/) page.
